/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration;

import java.util.Arrays;

public final class XMLConfig {
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_LICENSE_REF = "license_ref";
    public static final String ATT_CLASS_NAME = "class";
    public static final String ATT_RESOURCE = "resource";
    public static final String ROOT = "rat-config";
    public static final String FAMILIES = "families";
    public static final String LICENSES = "licenses";
    public static final String LICENSE = "license";
    public static final String APPROVED = "approved";
    public static final String FAMILY = "family";
    public static final String NOTE = "note";
    public static final String MATCHERS = "matchers";
    public static final String MATCHER = "matcher";
    static final String[] LICENSE_CHILDREN = new String[]{"note", "matcher"};
    static final String[] LICENSE_INLINE = new String[]{"matcher"};
    static final String[][] INLINE_NODES = new String[][]{{"any", "enclosed"}, {"all", "enclosed"}, {"not", "enclosed"}, {"text", "simpleText"}};

    private XMLConfig() {
    }

    public static boolean isInlineNode(String parent, String child) {
        return Arrays.stream(INLINE_NODES).anyMatch(s -> s[0].equals(parent) && s[1].equals(child));
    }

    public static boolean isLicenseChild(String child) {
        return Arrays.asList(LICENSE_CHILDREN).contains(child);
    }

    public static boolean isLicenseInline(String child) {
        return Arrays.asList(LICENSE_INLINE).contains(child);
    }
}

