/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.xpm;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BasicCParser;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.xpm.XpmImagingParameters;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.palette.SimplePalette;

public class XpmImageParser
extends AbstractImageParser<XpmImagingParameters> {
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.XPM.getExtensions();
    private static Map<String, Integer> colorNames;
    private static final String DEFAULT_EXTENSION;
    private static final char[] WRITE_PALETTE;

    /*
     * Exception decompiling
     */
    private static void loadColorNames() throws ImagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        this.readXpmHeader(byteSource).dump(pw);
        return true;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.XPM};
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, XpmImagingParameters params) throws ImagingException, IOException {
        XpmParseResult result = this.parseXpmHeader(byteSource);
        return this.readXpmImage(result.xpmHeader, result.cParser);
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    public XpmImagingParameters getDefaultParameters() {
        return new XpmImagingParameters();
    }

    @Override
    public byte[] getIccProfileBytes(ByteSource byteSource, XpmImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, XpmImagingParameters params) throws ImagingException, IOException {
        XpmHeader xpmHeader = this.readXpmHeader(byteSource);
        boolean transparent = false;
        ImageInfo.ColorType colorType = ImageInfo.ColorType.BW;
        for (Map.Entry<Object, PaletteEntry> entry : xpmHeader.palette.entrySet()) {
            PaletteEntry paletteEntry = entry.getValue();
            if ((paletteEntry.getBestArgb() & 0xFF000000) != -16777216) {
                transparent = true;
            }
            if (paletteEntry.haveColor) {
                colorType = ImageInfo.ColorType.RGB;
                continue;
            }
            if (colorType == ImageInfo.ColorType.RGB || !paletteEntry.haveGray && !paletteEntry.haveGray4Level) continue;
            colorType = ImageInfo.ColorType.GRAYSCALE;
        }
        return new ImageInfo("XPM version 3", xpmHeader.numCharsPerPixel * 8, new ArrayList<String>(), ImageFormats.XPM, "X PixMap", xpmHeader.height, "image/x-xpixmap", 1, 0, 0.0f, 0, 0.0f, xpmHeader.width, false, transparent, true, colorType, ImageInfo.CompressionAlgorithm.NONE);
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, XpmImagingParameters params) throws ImagingException, IOException {
        XpmHeader xpmHeader = this.readXpmHeader(byteSource);
        return new Dimension(xpmHeader.width, xpmHeader.height);
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, XpmImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public String getName() {
        return "X PixMap";
    }

    private int parseColor(String color) throws ImagingException {
        if (color.charAt(0) == '#') {
            if ((color = color.substring(1)).length() == 3) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(1, 2), 16);
                int blue = Integer.parseInt(color.substring(2, 3), 16);
                return 0xFF000000 | red << 20 | green << 12 | blue << 4;
            }
            if (color.length() == 6) {
                return 0xFF000000 | Integer.parseInt(color, 16);
            }
            if (color.length() == 9) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(3, 4), 16);
                int blue = Integer.parseInt(color.substring(6, 7), 16);
                return 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (color.length() == 12) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(4, 5), 16);
                int blue = Integer.parseInt(color.substring(8, 9), 16);
                return 0xFF000000 | red << 16 | green << 8 | blue;
            }
            if (color.length() == 24) {
                int red = Integer.parseInt(color.substring(0, 1), 16);
                int green = Integer.parseInt(color.substring(8, 9), 16);
                int blue = Integer.parseInt(color.substring(16, 17), 16);
                return 0xFF000000 | red << 16 | green << 8 | blue;
            }
            return 0;
        }
        if (color.charAt(0) == '%') {
            throw new ImagingException("HSV colors are not implemented even in the XPM specification!");
        }
        if ("None".equals(color)) {
            return 0;
        }
        XpmImageParser.loadColorNames();
        String colorLowercase = color.toLowerCase(Locale.ROOT);
        return colorNames.getOrDefault(colorLowercase, 0);
    }

    private boolean parseNextString(BasicCParser cParser, StringBuilder stringBuilder) throws IOException, ImagingException {
        stringBuilder.setLength(0);
        String token = cParser.nextToken();
        if (token.charAt(0) != '\"') {
            throw new ImagingException("Parsing XPM file failed, no string found where expected");
        }
        BasicCParser.unescapeString(stringBuilder, token);
        token = cParser.nextToken();
        while (token.charAt(0) == '\"') {
            BasicCParser.unescapeString(stringBuilder, token);
            token = cParser.nextToken();
        }
        if (",".equals(token)) {
            return true;
        }
        if ("}".equals(token)) {
            return false;
        }
        throw new ImagingException("Parsing XPM file failed, no ',' or '}' found where expected");
    }

    private void parsePaletteEntries(XpmHeader xpmHeader, BasicCParser cParser) throws IOException, ImagingException {
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < xpmHeader.numColors; ++i) {
            row.setLength(0);
            boolean hasMore = this.parseNextString(cParser, row);
            if (!hasMore) {
                throw new ImagingException("Parsing XPM file failed, file ended while reading palette");
            }
            String name = row.substring(0, xpmHeader.numCharsPerPixel);
            String[] tokens = BasicCParser.tokenizeRow(row.substring(xpmHeader.numCharsPerPixel));
            PaletteEntry paletteEntry = new PaletteEntry();
            paletteEntry.index = i;
            int previousKeyIndex = Integer.MIN_VALUE;
            StringBuilder colorBuffer = new StringBuilder();
            for (int j = 0; j < tokens.length; ++j) {
                String token = tokens[j];
                boolean isKey = false;
                if (previousKeyIndex < j - 1 && "m".equals(token) || "g4".equals(token) || "g".equals(token) || "c".equals(token) || "s".equals(token)) {
                    isKey = true;
                }
                if (isKey) {
                    if (previousKeyIndex >= 0) {
                        String key = tokens[previousKeyIndex];
                        String color = colorBuffer.toString();
                        colorBuffer.setLength(0);
                        this.populatePaletteEntry(paletteEntry, key, color);
                    }
                    previousKeyIndex = j;
                    continue;
                }
                if (previousKeyIndex < 0) break;
                if (colorBuffer.length() > 0) {
                    colorBuffer.append(' ');
                }
                colorBuffer.append(token);
            }
            if (previousKeyIndex >= 0 && colorBuffer.length() > 0) {
                String key = tokens[previousKeyIndex];
                String color = colorBuffer.toString();
                colorBuffer.setLength(0);
                this.populatePaletteEntry(paletteEntry, key, color);
            }
            xpmHeader.palette.put(name, paletteEntry);
        }
    }

    private XpmHeader parseXpmHeader(BasicCParser cParser) throws ImagingException, IOException {
        String token = cParser.nextToken();
        if (!"static".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no 'static' token");
        }
        token = cParser.nextToken();
        if (!"char".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no 'char' token");
        }
        token = cParser.nextToken();
        if (!"*".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no '*' token");
        }
        String name = cParser.nextToken();
        if (name == null) {
            throw new ImagingException("Parsing XPM file failed, no variable name");
        }
        if (name.charAt(0) != '_' && !Character.isLetter(name.charAt(0))) {
            throw new ImagingException("Parsing XPM file failed, variable name doesn't start with letter or underscore");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new ImagingException("Parsing XPM file failed, variable name contains non-letter non-digit non-underscore");
        }
        token = cParser.nextToken();
        if (!"[".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no '[' token");
        }
        token = cParser.nextToken();
        if (!"]".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no ']' token");
        }
        token = cParser.nextToken();
        if (!"=".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no '=' token");
        }
        token = cParser.nextToken();
        if (!"{".equals(token)) {
            throw new ImagingException("Parsing XPM file failed, no '{' token");
        }
        StringBuilder row = new StringBuilder();
        boolean hasMore = this.parseNextString(cParser, row);
        if (!hasMore) {
            throw new ImagingException("Parsing XPM file failed, file too short");
        }
        XpmHeader xpmHeader = this.parseXpmValuesSection(row.toString());
        this.parsePaletteEntries(xpmHeader, cParser);
        return xpmHeader;
    }

    private XpmParseResult parseXpmHeader(ByteSource byteSource) throws ImagingException, IOException {
        try (InputStream is = byteSource.getInputStream();){
            StringBuilder firstComment = new StringBuilder();
            ByteArrayOutputStream preprocessedFile = BasicCParser.preprocess(is, firstComment, null);
            if (!"XPM".equals(firstComment.toString().trim())) {
                throw new ImagingException("Parsing XPM file failed, signature isn't '/* XPM */'");
            }
            XpmParseResult xpmParseResult = new XpmParseResult();
            xpmParseResult.cParser = new BasicCParser(new ByteArrayInputStream(preprocessedFile.toByteArray()));
            xpmParseResult.xpmHeader = this.parseXpmHeader(xpmParseResult.cParser);
            XpmParseResult xpmParseResult2 = xpmParseResult;
            return xpmParseResult2;
        }
    }

    private XpmHeader parseXpmValuesSection(String row) throws ImagingException {
        String[] tokens = BasicCParser.tokenizeRow(row);
        if (tokens.length < 4 || tokens.length > 7) {
            throw new ImagingException("Parsing XPM file failed, <Values> section has incorrect tokens");
        }
        try {
            int width = Integer.parseInt(tokens[0]);
            int height = Integer.parseInt(tokens[1]);
            int numColors = Integer.parseInt(tokens[2]);
            int numCharsPerPixel = Integer.parseInt(tokens[3]);
            int xHotSpot = -1;
            int yHotSpot = -1;
            boolean xpmExt = false;
            if (tokens.length >= 6) {
                xHotSpot = Integer.parseInt(tokens[4]);
                yHotSpot = Integer.parseInt(tokens[5]);
            }
            if (tokens.length == 5 || tokens.length == 7) {
                if (!"XPMEXT".equals(tokens[tokens.length - 1])) {
                    throw new ImagingException("Parsing XPM file failed, can't parse <Values> section XPMEXT");
                }
                xpmExt = true;
            }
            return new XpmHeader(width, height, numColors, numCharsPerPixel, xHotSpot, yHotSpot, xpmExt);
        }
        catch (NumberFormatException nfe) {
            throw new ImagingException("Parsing XPM file failed, error parsing <Values> section", nfe);
        }
    }

    private String pixelsForIndex(int index, int charsPerPixel) {
        int i;
        StringBuilder stringBuilder = new StringBuilder();
        int highestPower = 1;
        for (i = 1; i < charsPerPixel; ++i) {
            highestPower *= WRITE_PALETTE.length;
        }
        for (i = 0; i < charsPerPixel; ++i) {
            int multiple = index / highestPower;
            index -= multiple * highestPower;
            highestPower /= WRITE_PALETTE.length;
            stringBuilder.append(WRITE_PALETTE[multiple]);
        }
        return stringBuilder.toString();
    }

    private void populatePaletteEntry(PaletteEntry paletteEntry, String key, String color) throws ImagingException {
        switch (key) {
            case "m": {
                paletteEntry.monoArgb = this.parseColor(color);
                paletteEntry.haveMono = true;
                break;
            }
            case "g4": {
                paletteEntry.gray4LevelArgb = this.parseColor(color);
                paletteEntry.haveGray4Level = true;
                break;
            }
            case "g": {
                paletteEntry.grayArgb = this.parseColor(color);
                paletteEntry.haveGray = true;
                break;
            }
            case "s": 
            case "c": {
                paletteEntry.colorArgb = this.parseColor(color);
                paletteEntry.haveColor = true;
                break;
            }
        }
    }

    private String randomName() {
        int i;
        UUID uuid = UUID.randomUUID();
        StringBuilder stringBuilder = new StringBuilder("a");
        long bits = uuid.getMostSignificantBits();
        for (i = 56; i >= 0; i -= 8) {
            stringBuilder.append(Integer.toHexString((int)(bits >> i & 0xFFL)));
        }
        bits = uuid.getLeastSignificantBits();
        for (i = 56; i >= 0; i -= 8) {
            stringBuilder.append(Integer.toHexString((int)(bits >> i & 0xFFL)));
        }
        return stringBuilder.toString();
    }

    private XpmHeader readXpmHeader(ByteSource byteSource) throws ImagingException, IOException {
        return this.parseXpmHeader((ByteSource)byteSource).xpmHeader;
    }

    private BufferedImage readXpmImage(XpmHeader xpmHeader, BasicCParser cParser) throws ImagingException, IOException {
        int bpp;
        WritableRaster raster;
        int size;
        boolean pixelStride;
        int scanlineStride;
        boolean bands;
        ColorModel colorModel;
        int[] palette;
        if (xpmHeader.palette.size() <= 256) {
            palette = Allocator.intArray(xpmHeader.palette.size());
            for (Map.Entry<Object, PaletteEntry> entry : xpmHeader.palette.entrySet()) {
                PaletteEntry paletteEntry = entry.getValue();
                palette[paletteEntry.index] = paletteEntry.getBestArgb();
            }
            colorModel = new IndexColorModel(8, xpmHeader.palette.size(), palette, 0, true, -1, 0);
            bands = true;
            scanlineStride = xpmHeader.width * 1;
            pixelStride = true;
            size = scanlineStride * (xpmHeader.height - 1) + 1 * xpmHeader.width;
            Allocator.check(8, size);
            raster = Raster.createInterleavedRaster(0, xpmHeader.width, xpmHeader.height, 1, null);
            bpp = 8;
        } else if (xpmHeader.palette.size() <= 65536) {
            palette = Allocator.intArray(xpmHeader.palette.size());
            for (Map.Entry<Object, PaletteEntry> entry : xpmHeader.palette.entrySet()) {
                PaletteEntry paletteEntry = entry.getValue();
                palette[paletteEntry.index] = paletteEntry.getBestArgb();
            }
            colorModel = new IndexColorModel(16, xpmHeader.palette.size(), palette, 0, true, -1, 1);
            bands = true;
            scanlineStride = xpmHeader.width * 1;
            pixelStride = true;
            size = scanlineStride * (xpmHeader.height - 1) + 1 * xpmHeader.width;
            Allocator.check(16, size);
            raster = Raster.createInterleavedRaster(1, xpmHeader.width, xpmHeader.height, 1, null);
            bpp = 16;
        } else {
            colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            Allocator.check(32, xpmHeader.width * xpmHeader.height);
            raster = Raster.createPackedRaster(3, xpmHeader.width, xpmHeader.height, new int[]{0xFF0000, 65280, 255, -16777216}, null);
            bpp = 32;
        }
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), new Properties());
        DataBuffer dataBuffer = raster.getDataBuffer();
        StringBuilder row = new StringBuilder();
        boolean hasMore = true;
        for (int y = 0; y < xpmHeader.height; ++y) {
            row.setLength(0);
            hasMore = this.parseNextString(cParser, row);
            if (y < xpmHeader.height - 1 && !hasMore) {
                throw new ImagingException("Parsing XPM file failed, insufficient image rows in file");
            }
            int rowOffset = y * xpmHeader.width;
            for (int x = 0; x < xpmHeader.width; ++x) {
                String index = row.substring(x * xpmHeader.numCharsPerPixel, (x + 1) * xpmHeader.numCharsPerPixel);
                PaletteEntry paletteEntry = xpmHeader.palette.get(index);
                if (paletteEntry == null) {
                    throw new ImagingException("No palette entry was defined for " + index);
                }
                if (bpp <= 16) {
                    dataBuffer.setElem(rowOffset + x, paletteEntry.index);
                    continue;
                }
                dataBuffer.setElem(rowOffset + x, paletteEntry.getBestArgb());
            }
        }
        while (hasMore) {
            row.setLength(0);
            hasMore = this.parseNextString(cParser, row);
        }
        String token = cParser.nextToken();
        if (!";".equals(token)) {
            throw new ImagingException("Last token wasn't ';'");
        }
        return image;
    }

    private String toColor(int color) {
        String hex = Integer.toHexString(color);
        if (hex.length() < 6) {
            char[] zeroes = Allocator.charArray(6 - hex.length());
            Arrays.fill(zeroes, '0');
            return "#" + new String(zeroes) + hex;
        }
        return "#" + hex;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, XpmImagingParameters params) throws ImagingException, IOException {
        PaletteFactory paletteFactory = new PaletteFactory();
        boolean hasTransparency = paletteFactory.hasTransparency(src, 1);
        SimplePalette palette = null;
        int maxColors = WRITE_PALETTE.length;
        int charsPerPixel = 1;
        while (palette == null) {
            palette = paletteFactory.makeExactRgbPaletteSimple(src, hasTransparency ? maxColors - 1 : maxColors);
            long nextMaxColors = maxColors * WRITE_PALETTE.length;
            long nextCharsPerPixel = charsPerPixel + 1;
            if (nextMaxColors > Integer.MAX_VALUE) {
                throw new ImagingException("Xpm: Can't write images with more than Integer.MAX_VALUE colors.");
            }
            if (nextCharsPerPixel > Integer.MAX_VALUE) {
                throw new ImagingException("Xpm: Can't write images with more than Integer.MAX_VALUE chars per pixel.");
            }
            if (palette != null) continue;
            maxColors *= WRITE_PALETTE.length;
            ++charsPerPixel;
        }
        int colors = palette.length();
        if (hasTransparency) {
            ++colors;
        }
        String line = "/* XPM */\n";
        os.write(line.getBytes(StandardCharsets.US_ASCII));
        line = "static char *" + this.randomName() + "[] = {\n";
        os.write(line.getBytes(StandardCharsets.US_ASCII));
        line = "\"" + src.getWidth() + " " + src.getHeight() + " " + colors + " " + charsPerPixel + "\",\n";
        os.write(line.getBytes(StandardCharsets.US_ASCII));
        for (int i = 0; i < colors; ++i) {
            String color = i < palette.length() ? this.toColor(palette.getEntry(i)) : "None";
            line = "\"" + this.pixelsForIndex(i, charsPerPixel) + " c " + color + "\",\n";
            os.write(line.getBytes(StandardCharsets.US_ASCII));
        }
        String separator = "";
        for (int y = 0; y < src.getHeight(); ++y) {
            os.write(separator.getBytes(StandardCharsets.US_ASCII));
            separator = ",\n";
            line = "\"";
            os.write(line.getBytes(StandardCharsets.US_ASCII));
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                line = (argb & 0xFF000000) == 0 ? this.pixelsForIndex(palette.length(), charsPerPixel) : this.pixelsForIndex(palette.getPaletteIndex(0xFFFFFF & argb), charsPerPixel);
                os.write(line.getBytes(StandardCharsets.US_ASCII));
            }
            line = "\"";
            os.write(line.getBytes(StandardCharsets.US_ASCII));
        }
        line = "\n};\n";
        os.write(line.getBytes(StandardCharsets.US_ASCII));
    }

    static {
        DEFAULT_EXTENSION = ImageFormats.XPM.getDefaultExtension();
        WRITE_PALETTE = new char[]{' ', '.', 'X', 'o', 'O', '+', '@', '#', '$', '%', '&', '*', '=', '-', ';', ':', '>', ',', '<', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'M', 'N', 'B', 'V', 'C', 'Z', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'P', 'I', 'U', 'Y', 'T', 'R', 'E', 'W', 'Q', '!', '~', '^', '/', '(', ')', '_', '`', '\'', ']', '[', '{', '}', '|'};
    }

    private static final class XpmHeader {
        final int height;
        final int numCharsPerPixel;
        final int numColors;
        final Map<Object, PaletteEntry> palette = new HashMap<Object, PaletteEntry>();
        final int width;
        int xHotSpot = -1;
        final boolean xpmExt;
        int yHotSpot = -1;

        XpmHeader(int width, int height, int numColors, int numCharsPerPixel, int xHotSpot, int yHotSpot, boolean xpmExt) {
            this.width = width;
            this.height = height;
            this.numColors = numColors;
            this.numCharsPerPixel = numCharsPerPixel;
            this.xHotSpot = xHotSpot;
            this.yHotSpot = yHotSpot;
            this.xpmExt = xpmExt;
        }

        public void dump(PrintWriter pw) {
            pw.println("XpmHeader");
            pw.println("Width: " + this.width);
            pw.println("Height: " + this.height);
            pw.println("NumColors: " + this.numColors);
            pw.println("NumCharsPerPixel: " + this.numCharsPerPixel);
            if (this.xHotSpot != -1 && this.yHotSpot != -1) {
                pw.println("X hotspot: " + this.xHotSpot);
                pw.println("Y hotspot: " + this.yHotSpot);
            }
            pw.println("XpmExt: " + this.xpmExt);
        }
    }

    private static final class XpmParseResult {
        BasicCParser cParser;
        XpmHeader xpmHeader;

        private XpmParseResult() {
        }
    }

    private static final class PaletteEntry {
        int colorArgb;
        int gray4LevelArgb;
        int grayArgb;
        boolean haveColor;
        boolean haveGray;
        boolean haveGray4Level;
        boolean haveMono;
        int index;
        int monoArgb;

        private PaletteEntry() {
        }

        int getBestArgb() {
            if (this.haveColor) {
                return this.colorArgb;
            }
            if (this.haveGray) {
                return this.grayArgb;
            }
            if (this.haveGray4Level) {
                return this.gray4LevelArgb;
            }
            if (this.haveMono) {
                return this.monoArgb;
            }
            return 0;
        }
    }
}

