/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.apache.commons.imaging.formats.tiff.TiffImageParser;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.mylzw.MyLzwCompressor;
import org.apache.commons.imaging.mylzw.MyLzwDecompressor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TiffLzwTest
extends AbstractTiffTest {
    private void compressRoundtripAndValidate(byte[] src) throws IOException, ImagingException {
        boolean DEBUG = false;
        int LZW_MINIMUM_CODE_SIZE = 8;
        final ArrayList codes = new ArrayList();
        MyLzwCompressor.Listener compressionListener = new MyLzwCompressor.Listener(){

            public void clearCode(int code) {
                codes.add(code);
            }

            public void dataCode(int code) {
                codes.add(code);
            }

            public void eoiCode(int code) {
                codes.add(code);
            }

            public void init(int clearCode, int eoiCode) {
            }
        };
        MyLzwCompressor compressor = new MyLzwCompressor(8, ByteOrder.BIG_ENDIAN, true, compressionListener);
        byte[] compressed = compressor.compress(src);
        MyLzwDecompressor.Listener decompressionListener = new MyLzwDecompressor.Listener(){
            int index;
            int clearCode;
            int eoiCode;

            public void code(int code) {
                Integer expectedCode;
                if (code != (expectedCode = (Integer)codes.get(this.index++))) {
                    Debug.debug((String)("bad code: " + this.index + "/" + codes.size()));
                    Debug.debug((String)("code: " + code + " (0x" + Integer.toHexString(code) + ") " + Integer.toBinaryString(code)));
                    Debug.debug((String)("expected: " + expectedCode + " (0x" + Integer.toHexString(expectedCode) + ") " + Integer.toBinaryString(expectedCode)));
                    Debug.debug((String)("clearCode: " + this.clearCode + " (0x" + Integer.toHexString(this.clearCode) + ") " + Integer.toBinaryString(this.clearCode)));
                    Debug.debug((String)("eoiCode: " + this.eoiCode + " (0x" + Integer.toHexString(this.eoiCode) + ") " + Integer.toBinaryString(this.eoiCode)));
                    Debug.debug();
                }
            }

            public void init(int clearCode, int eoiCode) {
                this.clearCode = clearCode;
                this.eoiCode = eoiCode;
            }
        };
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        MyLzwDecompressor decompressor = new MyLzwDecompressor(8, ByteOrder.BIG_ENDIAN, true, decompressionListener);
        byte[] decompressed = decompressor.decompress((InputStream)is, src.length);
        Assertions.assertEquals((int)src.length, (int)decompressed.length);
        for (int i = 0; i < src.length; ++i) {
            Assertions.assertEquals((byte)src[i], (byte)decompressed[i]);
        }
    }

    private void decompressRoundtripAndValidate(byte[] src) throws IOException, ImagingException {
        Debug.debug();
        Debug.debug((String)("roundtripAndValidate: " + src.length));
        Debug.debug();
        int LZW_MINIMUM_CODE_SIZE = 8;
        final ArrayList codes = new ArrayList();
        MyLzwDecompressor.Listener decompressionListener = new MyLzwDecompressor.Listener(){

            public void code(int code) {
                Debug.debug((String)("listener code: " + code + " (0x" + Integer.toHexString(code) + ") " + Integer.toBinaryString(code) + ", index: " + codes.size()));
                codes.add(code);
            }

            public void init(int clearCode, int eoiCode) {
            }
        };
        ByteArrayInputStream is = new ByteArrayInputStream(src);
        MyLzwDecompressor decompressor = new MyLzwDecompressor(8, ByteOrder.BIG_ENDIAN, true, decompressionListener);
        byte[] decompressed = decompressor.decompress((InputStream)is, src.length);
        MyLzwCompressor.Listener compressionListener = new MyLzwCompressor.Listener(){
            int clearCode;
            int eoiCode;
            int index;

            public void clearCode(int code) {
                this.code(code);
            }

            private void code(int code) {
                Integer expectedCode;
                if (code == this.clearCode) {
                    Debug.debug((String)("clearCode: " + this.index + "/" + codes.size()));
                    Debug.debug();
                }
                if (code == this.eoiCode) {
                    Debug.debug((String)("eoiCode: " + this.index + "/" + codes.size()));
                    Debug.debug();
                }
                if (code != (expectedCode = (Integer)codes.get(this.index++))) {
                    Debug.debug((String)("bad code: " + this.index + "/" + codes.size()));
                    Debug.debug((String)("code: " + code + " (0x" + Integer.toHexString(code) + ") " + Integer.toBinaryString(code)));
                    Debug.debug((String)("expected: " + expectedCode + " (0x" + Integer.toHexString(expectedCode) + ") " + Integer.toBinaryString(expectedCode)));
                    Debug.debug((String)("clearCode: " + this.clearCode + " (0x" + Integer.toHexString(this.clearCode) + ") " + Integer.toBinaryString(this.clearCode)));
                    Debug.debug((String)("eoiCode: " + this.eoiCode + " (0x" + Integer.toHexString(this.eoiCode) + ") " + Integer.toBinaryString(this.eoiCode)));
                    Debug.debug();
                }
            }

            public void dataCode(int code) {
                this.code(code);
            }

            public void eoiCode(int code) {
                this.code(code);
            }

            public void init(int clearCode, int eoiCode) {
                this.clearCode = clearCode;
                this.eoiCode = eoiCode;
            }
        };
        MyLzwCompressor compressor = new MyLzwCompressor(8, ByteOrder.BIG_ENDIAN, true, compressionListener);
        byte[] compressed = compressor.compress(decompressed);
        Assertions.assertEquals((int)src.length, (int)compressed.length);
        for (int i = 0; i < src.length; ++i) {
            Assertions.assertEquals((byte)src[i], (byte)compressed[i]);
        }
    }

    @Test
    public void testMedium() throws Exception {
        int LENGTH = 32768;
        byte[] bytes = new byte[32768];
        for (int modulator = 1; modulator < 255; modulator += 3) {
            for (int i = 0; i < 32768; ++i) {
                bytes[i] = (byte)(0xFF & i % modulator);
            }
            this.compressRoundtripAndValidate(bytes);
        }
    }

    @Disabled
    @Test
    public void testTiffImageData() throws IOException, ImagingException {
        List<File> images = this.getTiffImages();
        for (File image : images) {
            Debug.debug((String)"imageFile", (Object)image);
            ByteSource byteSource = ByteSource.file((File)image);
            List data = new TiffImageParser().collectRawImageData(byteSource, new TiffImagingParameters());
            for (byte[] bytes : data) {
                this.decompressRoundtripAndValidate(bytes);
            }
        }
    }

    @Test
    public void testTrivial() throws Exception {
        byte[] bytes = new byte[]{0};
        this.compressRoundtripAndValidate(bytes);
    }
}

