/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.imaging.ImagingConstants;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.png.chunks.PngChunkIccp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngChunkIccpTest {
    private static final int chunkType = 1766015824;

    @Test
    public void testErrorOnNoProfileName() {
        byte[] data = ImagingConstants.EMPTY_BYTE_ARRAY;
        Assertions.assertThrows(ImagingException.class, () -> new PngChunkIccp(0, 1766015824, 0, data));
    }

    @Test
    public void testParsingIccpChunk() throws ImagingException, IOException {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        String profileName = "my-profile-01";
        for (byte b : "my-profile-01".getBytes(StandardCharsets.ISO_8859_1)) {
            bytes.add(b);
        }
        bytes.add((byte)0);
        bytes.add((byte)0);
        byte[] uncompressedData = new byte[100];
        IntStream.range(0, 100).forEach(i -> {
            uncompressedData[i] = (byte)(i + 1);
        });
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(100);){
            Deflater def = new Deflater();
            try (DeflaterOutputStream ios = new DeflaterOutputStream((OutputStream)baos, def);){
                ios.write(uncompressedData);
            }
            baos.flush();
            byte[] compressedData = baos.toByteArray();
            byte[] data = new byte[bytes.size() + compressedData.length];
            for (int i2 = 0; i2 < bytes.size(); ++i2) {
                data[i2] = (Byte)bytes.get(i2);
            }
            IntStream.range(0, compressedData.length).forEach(i -> {
                data[bytes.size() + i] = compressedData[i];
            });
            PngChunkIccp chunk = new PngChunkIccp(data.length, 1766015824, 0, data);
            Assertions.assertArrayEquals((byte[])uncompressedData, (byte[])chunk.getUncompressedProfile());
        }
    }
}

