/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.LoopingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoopingIteratorTest {
    @Test
    public void testConstructorEx() {
        Assertions.assertThrows(NullPointerException.class, () -> new LoopingIterator(null));
    }

    @Test
    public void testLooping0() {
        ArrayList list = new ArrayList();
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertFalse((boolean)loop.hasNext(), (String)"hasNext should return false");
        Assertions.assertThrows(NoSuchElementException.class, () -> loop.next(), (String)"NoSuchElementException was not thrown during next() call.");
    }

    @Test
    public void testLooping1() {
        List<String> list = Arrays.asList("a");
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"1st hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"2nd hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"3rd hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testLooping2() {
        List<String> list = Arrays.asList("a", "b");
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"1st hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"2nd hasNext should return true");
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"3rd hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testLooping3() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"1st hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"2nd hasNext should return true");
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"3rd hasNext should return true");
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"4th hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
    }

    @Test
    public void testRemoving1() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertEquals((int)3, (int)list.size(), (String)"list should have 3 elements.");
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"1st hasNext should return true");
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        loop.remove();
        Assertions.assertEquals((int)2, (int)list.size(), (String)"list should have 2 elements.");
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"2nd hasNext should return true");
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        loop.remove();
        Assertions.assertEquals((int)1, (int)list.size(), (String)"list should have 1 elements.");
        Assertions.assertTrue((boolean)loop.hasNext(), (String)"3rd hasNext should return true");
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        loop.remove();
        Assertions.assertEquals((int)0, (int)list.size(), (String)"list should have 0 elements.");
        Assertions.assertFalse((boolean)loop.hasNext(), (String)"4th hasNext should return false");
        Assertions.assertThrows(NoSuchElementException.class, () -> loop.next(), (String)"Expected NoSuchElementException to be thrown.");
    }

    @Test
    public void testReset() {
        List<String> list = Arrays.asList("a", "b", "c");
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
        loop.reset();
        Assertions.assertEquals((Object)"a", (Object)loop.next());
        Assertions.assertEquals((Object)"b", (Object)loop.next());
        Assertions.assertEquals((Object)"c", (Object)loop.next());
    }

    @Test
    public void testSize() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        LoopingIterator loop = new LoopingIterator(list);
        Assertions.assertEquals((int)3, (int)loop.size());
        loop.next();
        loop.next();
        Assertions.assertEquals((int)3, (int)loop.size());
        loop.reset();
        Assertions.assertEquals((int)3, (int)loop.size());
        loop.next();
        loop.remove();
        Assertions.assertEquals((int)2, (int)loop.size());
    }
}

