/*
 * Decompiled with CFR 0.152.
 */
package sandesha2.samples.userguide;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.util.SandeshaUtil;

public class MTOMPingClient {
    private static final String applicationNamespaceName = "http://tempuri.org/";
    private static final String MTOMPing = "MTOMPing";
    private String toIP = "127.0.0.1";
    private String toPort = "8080";
    private String transportToPort = "8070";
    private String toEPR = "http://" + this.toIP + ":" + this.toPort + "/axis2/services/RMSampleService";
    private String transportToEPR = "http://" + this.toIP + ":" + this.transportToPort + "/axis2/services/RMSampleService";
    private static String SANDESHA2_HOME = "<SANDESHA2_HOME>";
    private static String AXIS2_CLIENT_PATH = SANDESHA2_HOME + File.separator + "target" + File.separator + "repos" + File.separator + "client" + File.separator;

    public static void main(String[] args) throws AxisFault {
        String axisClientRepo = null;
        if (args != null && args.length > 0) {
            axisClientRepo = args[0];
        }
        if (axisClientRepo != null && !"".equals(axisClientRepo)) {
            AXIS2_CLIENT_PATH = axisClientRepo;
            SANDESHA2_HOME = "";
        }
        new MTOMPingClient().run();
    }

    private void run() throws AxisFault {
        if ("<SANDESHA2_HOME>".equals(SANDESHA2_HOME)) {
            System.out.println("ERROR: Please change <SANDESHA2_HOME> to your Sandesha2 installation directory.");
            return;
        }
        String axis2_xml = AXIS2_CLIENT_PATH + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)AXIS2_CLIENT_PATH, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setProperty("TransportURL", (Object)this.transportToEPR);
        clientOptions.setTo(new EndpointReference(this.toEPR));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty("Sandesha2SequenceKey", (Object)sequenceKey);
        clientOptions.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        clientOptions.setProperty("Sandesha2Listener", (Object)new SandeshaListenerImpl());
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.engageModule("sandesha2");
        clientOptions.setAction("urn:wsrm:Ping");
        serviceClient.setOptions(clientOptions);
        clientOptions.setProperty("Sandesha2LastMessage", (Object)"true");
        serviceClient.fireAndForget(MTOMPingClient.getPingOMBlock());
        SandeshaClient.waitUntilSequenceCompleted((ServiceClient)serviceClient);
        serviceClient.cleanup();
    }

    private static OMElement getPingOMBlock() throws AxisFault {
        FileDataSource dataSource;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace(applicationNamespaceName, "ns1");
        OMElement pingElem = fac.createOMElement(MTOMPing, namespace);
        OMElement attachmentElem = fac.createOMElement("Attachment", namespace);
        String imageName = "test-resources" + File.separator + "mtom-image.jpg";
        try {
            dataSource = new FileDataSource(new File(imageName));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        OMText textData = fac.createOMText((Object)dataHandler, true);
        attachmentElem.addChild((OMNode)textData);
        pingElem.addChild((OMNode)attachmentElem);
        return pingElem;
    }

    private class SandeshaListenerImpl
    implements SandeshaListener {
        private SandeshaListenerImpl() {
        }

        public void onError(AxisFault fault) {
            System.out.println("*********** RM fault callbak called");
        }

        public void onTimeOut(SequenceReport report) {
            System.out.println("Sequence timed out");
        }
    }
}

