/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.Expires;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.SequenceOffer;

public class CreateSequence
implements IOMRMPart {
    private AcksTo acksTo = null;
    private Expires expires = null;
    private SequenceOffer sequenceOffer = null;
    private String rmNamespaceValue = null;
    private String secNamespaceValue = null;
    private OMElement securityTokenReference = null;

    public CreateSequence(String rmNamespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(rmNamespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", rmNamespaceValue));
        }
        this.rmNamespaceValue = rmNamespaceValue;
        this.secNamespaceValue = SpecSpecificConstants.getSecurityNamespace(rmNamespaceValue);
    }

    public CreateSequence(AcksTo acksTo, SOAPFactory factory, String rmNamespaceValue) throws SandeshaException {
        this(rmNamespaceValue);
        this.acksTo = acksTo;
    }

    public String getNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public String getAddressingNamespaceValue() {
        if (this.acksTo != null) {
            return this.acksTo.getAddressingNamespaceValue();
        }
        return null;
    }

    public Object fromOMElement(OMElement bodyElement) throws OMException, AxisFault {
        OMElement expiresPart;
        OMElement createSequencePart = bodyElement.getFirstChildWithName(new QName(this.rmNamespaceValue, "CreateSequence"));
        if (createSequencePart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noCreateSeqPartInElement", bodyElement.toString()));
        }
        this.acksTo = new AcksTo(this.rmNamespaceValue);
        this.acksTo.fromOMElement(createSequencePart);
        OMElement offerPart = createSequencePart.getFirstChildWithName(new QName(this.rmNamespaceValue, "Offer"));
        if (offerPart != null) {
            this.sequenceOffer = new SequenceOffer(this.rmNamespaceValue);
            this.sequenceOffer.fromOMElement(createSequencePart);
        }
        if ((expiresPart = createSequencePart.getFirstChildWithName(new QName(this.rmNamespaceValue, "Expires"))) != null) {
            this.expires = new Expires(this.rmNamespaceValue);
            this.expires.fromOMElement(createSequencePart);
        }
        if (this.secNamespaceValue != null) {
            this.securityTokenReference = createSequencePart.getFirstChildWithName(new QName(this.secNamespaceValue, "SecurityTokenReference"));
        }
        return this;
    }

    public OMElement toOMElement(OMElement bodyElement) throws OMException, AxisFault {
        if (bodyElement == null || !(bodyElement instanceof SOAPBody)) {
            throw new OMException(SandeshaMessageHelper.getMessage("createSeqCannotBeAddedToNonBody"));
        }
        if (this.acksTo == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("createSeqNullAcksTo"));
        }
        SOAPBody soapBody = (SOAPBody)bodyElement;
        OMFactory factory = bodyElement.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.rmNamespaceValue, "wsrm");
        OMElement createSequenceElement = factory.createOMElement("CreateSequence", rmNamespace);
        this.acksTo.toOMElement(createSequenceElement);
        if (this.sequenceOffer != null) {
            this.sequenceOffer.toOMElement(createSequenceElement);
        }
        if (this.expires != null) {
            this.expires.toOMElement(createSequenceElement);
        }
        if (this.securityTokenReference != null) {
            createSequenceElement.addChild((OMNode)this.securityTokenReference);
        }
        soapBody.addChild((OMNode)createSequenceElement);
        return soapBody;
    }

    public void setAcksTo(AcksTo acksTo) {
        this.acksTo = acksTo;
    }

    public void setSequenceOffer(SequenceOffer sequenceOffer) {
        this.sequenceOffer = sequenceOffer;
    }

    public AcksTo getAcksTo() {
        return this.acksTo;
    }

    public SequenceOffer getSequenceOffer() {
        return this.sequenceOffer;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) throws AxisFault {
        SOAPBody body = envelope.getBody();
        OMElement elem = body.getFirstChildWithName(new QName(this.rmNamespaceValue, "CreateSequence"));
        if (elem != null) {
            elem.detach();
        }
        this.toOMElement((OMElement)body);
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }

    public OMElement getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(OMElement theSTR) {
        this.securityTokenReference = theSTR;
    }
}

