/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MessageRetransmissionAdjuster;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaWorker;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.TerminateSequence;

public class SenderWorker
extends SandeshaWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(SenderWorker.class);
    private ConfigurationContext configurationContext = null;
    private SenderBean senderBean = null;
    private RMMsgContext messageToSend = null;
    private String rmVersion = null;

    public SenderWorker(ConfigurationContext configurationContext, SenderBean senderBean, String rmVersion) {
        this.configurationContext = configurationContext;
        this.senderBean = senderBean;
        this.rmVersion = rmVersion;
    }

    public void setMessage(RMMsgContext msg) {
        this.messageToSend = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block98: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: SenderWorker::run");
            }
            if (this.lock != null && !this.lock.ownsLock(this.workId, this)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: SenderWorker::run, another worker holds the lock");
                }
                return;
            }
            Transaction transaction = null;
            try {
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, (AxisDescription)this.configurationContext.getAxisConfiguration());
                SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
                transaction = storageManager.getTransaction();
                String key = this.senderBean.getMessageContextRefKey();
                MessageContext msgCtx = null;
                RMMsgContext rmMsgCtx = null;
                if (this.messageToSend != null) {
                    msgCtx = this.messageToSend.getMessageContext();
                    rmMsgCtx = this.messageToSend;
                } else {
                    msgCtx = storageManager.retrieveMessageContext(key, this.configurationContext);
                    if (msgCtx == null) {
                        if (transaction != null && transaction.isActive()) {
                            transaction.commit();
                        }
                        transaction = null;
                        return;
                    }
                    rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                }
                String qualifiedForSending = (String)msgCtx.getProperty("Sandesha2QualifiedForSending");
                if (qualifiedForSending != null && !qualifiedForSending.equals("true")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: SenderWorker::run, !qualified for sending");
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                        transaction = null;
                    }
                    return;
                }
                if (msgCtx == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)SandeshaMessageHelper.getMessage("sendHasUnavailableMsgEntry"));
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                        transaction = null;
                    }
                    return;
                }
                ArrayList<Integer> msgsNotToSend = SandeshaUtil.getPropertyBean((AxisDescription)msgCtx.getAxisOperation()).getMsgTypesToDrop();
                if (msgsNotToSend != null && msgsNotToSend.contains(new Integer(rmMsgCtx.getMessageType()))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: SenderWorker::run, message type to be dropped " + rmMsgCtx.getMessageType()));
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                        transaction = null;
                    }
                    return;
                }
                Boolean makeConnection = (Boolean)msgCtx.getProperty("MakeConnectionResponse");
                EndpointReference toEPR = msgCtx.getTo();
                MessageContext inMsg = null;
                OperationContext op = msgCtx.getOperationContext();
                RequestResponseTransport t = (RequestResponseTransport)msgCtx.getProperty("RequestResponseTransportControl");
                if (t == null) {
                    if (op != null) {
                        inMsg = op.getMessageContext("In");
                    }
                    if (inMsg != null) {
                        t = (RequestResponseTransport)inMsg.getProperty("RequestResponseTransportControl");
                    }
                }
                if (!(toEPR != null && !toEPR.hasAnonymousAddress() || makeConnection != null && makeConnection.booleanValue() || t != null && t.getStatus().equals((Object)RequestResponseTransport.RequestResponseTransportStatus.WAITING))) {
                    SenderBean bean = senderBeanMgr.retrieve(this.senderBean.getMessageID());
                    if (bean != null && bean.isTransportAvailable()) {
                        bean.setTransportAvailable(false);
                        senderBeanMgr.update(bean);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: SenderWorker::run, no response transport for anonymous message");
                    }
                    return;
                }
                int messageType = this.senderBean.getMessageType();
                if (this.isAckPiggybackableMsgType(messageType)) {
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = storageManager.getTransaction();
                    AcknowledgementManager.piggybackAcksIfPresent(rmMsgCtx, storageManager);
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = storageManager.getTransaction();
                boolean ackPresent = false;
                Iterator<SequenceAcknowledgement> it = rmMsgCtx.getSequenceAcknowledgements();
                if (it.hasNext()) {
                    ackPresent = true;
                }
                if (!ackPresent && toEPR.hasAnonymousAddress() && rmMsgCtx.getMessageContext().isServerSide() && (messageType == 3 || messageType == 0 || messageType == 12)) {
                    String inboundSequenceId = this.senderBean.getInboundSequenceId();
                    if (inboundSequenceId == null) {
                        throw new SandeshaException("InboundSequenceID is not set for the sequence:" + this.senderBean.getSequenceID());
                    }
                    RMDBean incomingSequenceBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequenceId);
                    if (incomingSequenceBean != null) {
                        RMMsgCreator.addAckMessage(rmMsgCtx, inboundSequenceId, incomingSequenceBean, false, true);
                    }
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = storageManager.getTransaction();
                this.senderBean = this.updateMessage(rmMsgCtx, this.senderBean, storageManager);
                if (this.senderBean == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: SenderWorker::run, !continueSending");
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                        transaction = null;
                    }
                    return;
                }
                if (this.senderBean.isReSend()) {
                    senderBeanMgr.update(this.senderBean);
                }
                boolean successfullySent = false;
                if (3 != this.senderBean.getMessageType()) {
                    EndpointReference replyToEPR;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Redecorate EPR : " + msgCtx.getEnvelope().getHeader()));
                    }
                    if ((replyToEPR = msgCtx.getReplyTo()) != null) {
                        replyToEPR = SandeshaUtil.getEPRDecorator(msgCtx.getConfigurationContext()).decorateEndpointReference(replyToEPR);
                        msgCtx.setReplyTo(replyToEPR);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                    transaction = null;
                }
                boolean processResponseForFaults = false;
                try {
                    Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
                    if (storageManager.requiresMessageSerialization()) {
                        if (msgCtx.isPaused()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Resuming a send for message : " + msgCtx.getEnvelope().getHeader()));
                            }
                            msgCtx.setPaused(false);
                            msgCtx.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
                            response = AxisEngine.resumeSend((MessageContext)msgCtx);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Sending a message : " + msgCtx.getEnvelope().getHeader()));
                            }
                            msgCtx.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
                            AxisEngine.send((MessageContext)msgCtx);
                        }
                    } else {
                        ArrayList retransmittablePhases = (ArrayList)msgCtx.getProperty("RMRetransmittablePhases");
                        if (retransmittablePhases != null) {
                            msgCtx.setExecutionChain(retransmittablePhases);
                        } else {
                            ArrayList emptyExecutionChain = new ArrayList();
                            msgCtx.setExecutionChain(emptyExecutionChain);
                        }
                        msgCtx.setCurrentHandlerIndex(0);
                        msgCtx.setCurrentPhaseIndex(0);
                        msgCtx.setPaused(false);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Resuming a send for message : " + msgCtx.getEnvelope().getHeader()));
                        }
                        msgCtx.setProperty("transportNonBlocking", (Object)Boolean.FALSE);
                        response = AxisEngine.resumeSend((MessageContext)msgCtx);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Engine resume returned " + response));
                    }
                    if (response != Handler.InvocationResponse.SUSPEND && t != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Signalling transport in " + t));
                        }
                        t.signalResponseReady();
                    }
                    successfullySent = true;
                }
                catch (AxisFault e) {
                    processResponseForFaults = true;
                    this.recordError((Exception)((Object)e), rmMsgCtx, storageManager);
                }
                catch (Exception e) {
                    String message = SandeshaMessageHelper.getMessage("sendMsgError", e.toString());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)message, (Throwable)e);
                    }
                    this.recordError(e, rmMsgCtx, storageManager);
                }
                transaction = storageManager.getTransaction();
                SenderBean bean1 = senderBeanMgr.retrieve(this.senderBean.getMessageID());
                if (bean1 != null) {
                    if (this.senderBean.isReSend()) {
                        bean1.setTimeToSend(this.senderBean.getTimeToSend());
                        senderBeanMgr.update(bean1);
                    } else {
                        senderBeanMgr.delete(bean1.getMessageID());
                        String messageStoredKey = bean1.getMessageContextRefKey();
                        storageManager.removeMessageContext(messageStoredKey);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                }
                transaction = null;
                if ((processResponseForFaults || successfullySent) && !msgCtx.isServerSide()) {
                    this.checkForSyncResponses(msgCtx);
                }
                if (rmMsgCtx.getMessageType() != 7 || !"http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmMsgCtx.getRMNamespaceValue())) break block98;
                try {
                    transaction = storageManager.getTransaction();
                    TerminateSequence terminateSequence = rmMsgCtx.getTerminateSequence();
                    String sequenceID = terminateSequence.getIdentifier().getIdentifier();
                    RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID);
                    TerminateManager.terminateSendingSide(rmsBean, storageManager, false, null);
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                }
                finally {
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                        transaction = null;
                    }
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Caught exception", (Throwable)e);
                }
            }
            finally {
                block99: {
                    if (this.lock != null && this.workId != null) {
                        this.lock.removeWork(this.workId);
                    }
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                        }
                        catch (SandeshaStorageException e) {
                            if (!log.isWarnEnabled()) break block99;
                            log.warn((Object)"Caught exception rolling back transaction", (Throwable)((Object)e));
                        }
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SenderWorker::run");
        }
    }

    private SenderBean updateMessage(RMMsgContext rmMsgContext, SenderBean senderBean, StorageManager storageManager) throws AxisFault {
        senderBean = storageManager.getSenderBeanMgr().retrieve(senderBean.getMessageID());
        if (senderBean == null) {
            return senderBean;
        }
        int messageType = senderBean.getMessageType();
        boolean continueSending = MessageRetransmissionAdjuster.adjustRetransmittion(rmMsgContext, senderBean, rmMsgContext.getConfigurationContext(), storageManager);
        if (!continueSending) {
            return null;
        }
        Identifier id = null;
        if (messageType == 3 || messageType == 12) {
            String namespace = SpecSpecificConstants.getRMNamespaceValue(this.rmVersion);
            Sequence sequence = rmMsgContext.getSequence();
            if (sequence == null) {
                sequence = new Sequence(namespace);
                sequence.setMessageNumber(senderBean.getMessageNumber());
                if (senderBean.isLastMessage() && SpecSpecificConstants.isLastMessageIndicatorRequired(this.rmVersion)) {
                    sequence.setLastMessage(true);
                }
                id = new Identifier(namespace);
                sequence.setIdentifier(id);
                rmMsgContext.setSequence(sequence);
            }
        } else if (messageType == 7) {
            TerminateSequence terminate = rmMsgContext.getTerminateSequence();
            id = terminate.getIdentifier();
        } else if (messageType == 5) {
            CloseSequence close = rmMsgContext.getCloseSequence();
            id = close.getIdentifier();
        } else if (messageType == 8) {
            Iterator<AckRequested> ackRequests = rmMsgContext.getAckRequests();
            AckRequested ackRequest = ackRequests.next();
            if (ackRequests.hasNext()) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("ackRequestMultipleParts"));
            }
            id = ackRequest.getIdentifier();
        }
        if (id != null && !senderBean.getSequenceID().equals(id.getIdentifier())) {
            id.setIndentifer(senderBean.getSequenceID());
            rmMsgContext.addSOAPEnvelope();
        } else if (rmMsgContext.getProperty("ackToBeWritten") != null) {
            rmMsgContext.addSOAPEnvelope();
        }
        return senderBean;
    }

    private boolean isAckPiggybackableMsgType(int messageType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SenderWorker::isAckPiggybackableMsgType, " + messageType));
        }
        boolean piggybackable = true;
        if (messageType == 4) {
            piggybackable = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SenderWorker::isAckPiggybackableMsgType, " + piggybackable));
        }
        return piggybackable;
    }

    private void checkForSyncResponses(MessageContext msgCtx) {
        block23: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enter: SenderWorker::checkForSyncResponses, " + msgCtx.getEnvelope().getHeader()));
            }
            try {
                boolean transportInPresent;
                MessageContext responseMessageContext = msgCtx.getOperationContext().getMessageContext("In");
                SOAPEnvelope resenvelope = null;
                if (responseMessageContext != null) {
                    resenvelope = responseMessageContext.getEnvelope();
                }
                boolean bl = transportInPresent = msgCtx.getProperty("TRANSPORT_IN") != null;
                if (!(transportInPresent || responseMessageContext != null && responseMessageContext.getEnvelope() != null)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exit: SenderWorker::checkForSyncResponses, no response present");
                    }
                    return;
                }
                boolean syncResponseBuilt = false;
                if (responseMessageContext == null || responseMessageContext.getEnvelope() == null) {
                    AxisOperation operation;
                    if (responseMessageContext == null) {
                        responseMessageContext = new MessageContext();
                    }
                    OperationContext requestMsgOpCtx = msgCtx.getOperationContext();
                    SandeshaUtil.copyConfiguredProperties(msgCtx, responseMessageContext);
                    responseMessageContext.setProperty("CHARACTER_SET_ENCODING", requestMsgOpCtx.getProperty("CHARACTER_SET_ENCODING"));
                    responseMessageContext.setProperty("ContentType", requestMsgOpCtx.getProperty("ContentType"));
                    responseMessageContext.setProperty("MTOM_RECEIVED", requestMsgOpCtx.getProperty("MTOM_RECEIVED"));
                    HashMap transportInfoMap = (HashMap)msgCtx.getProperty("TransportInfoMap");
                    if (transportInfoMap != null) {
                        responseMessageContext.setProperty("ContentType", transportInfoMap.get("ContentType"));
                        responseMessageContext.setProperty("CHARACTER_SET_ENCODING", transportInfoMap.get("CHARACTER_SET_ENCODING"));
                    }
                    responseMessageContext.setConfigurationContext(msgCtx.getConfigurationContext());
                    responseMessageContext.setTransportIn(msgCtx.getTransportIn());
                    responseMessageContext.setTransportOut(msgCtx.getTransportOut());
                    responseMessageContext.setProperty("TRANSPORT_IN", msgCtx.getProperty("TRANSPORT_IN"));
                    responseMessageContext.setServiceGroupContext(msgCtx.getServiceGroupContext());
                    responseMessageContext.setProperty("Sandesha2MakeConnectionEntry", msgCtx.getProperty("Sandesha2MakeConnectionEntry"));
                    responseMessageContext.setDoingREST(msgCtx.isDoingREST());
                    resenvelope = responseMessageContext.getEnvelope();
                    try {
                        if (resenvelope == null) {
                            resenvelope = TransportUtils.createSOAPMessage((MessageContext)responseMessageContext, (boolean)true);
                            responseMessageContext.setEnvelope(resenvelope);
                            syncResponseBuilt = true;
                        }
                    }
                    catch (AxisFault e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)SandeshaMessageHelper.getMessage("soapEnvNotSet"));
                            log.debug((Object)"Caught exception", (Throwable)e);
                        }
                        return;
                    }
                    int messageType = MsgInitializer.initializeMessage(responseMessageContext).getMessageType();
                    RMMsgContext responseRMMessage = MsgInitializer.initializeMessage(responseMessageContext);
                    int responseMessageType = responseRMMessage.getMessageType();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("inboundMsgType" + responseMessageType + "outgoing message type " + messageType));
                    }
                    responseMessageContext.setAxisService(msgCtx.getAxisService());
                    Boolean addressingDisabled = (Boolean)msgCtx.getProperty("disableAddressingForOutMessages");
                    if (addressingDisabled != null && Boolean.TRUE.equals(addressingDisabled)) {
                        OperationContext responseMsgOpCtx = requestMsgOpCtx;
                        if (requestMsgOpCtx.getAxisOperation().getMessageReceiver() == null) {
                            ServiceContext serviceCtx = msgCtx.getServiceContext();
                            AxisOperation op = msgCtx.getAxisService().getOperation(Sandesha2Constants.RM_IN_ONLY_OPERATION);
                            responseMsgOpCtx = OperationContextFactory.createOperationContext((int)op.getAxisSpecificMEPConstant(), (AxisOperation)op, (ServiceContext)serviceCtx);
                        }
                        responseMessageContext.setOperationContext(responseMsgOpCtx);
                    }
                    if ((operation = msgCtx.getAxisOperation()) != null && responseMessageContext.getAxisMessage() == null && !(operation instanceof OutOnlyAxisOperation)) {
                        responseMessageContext.setAxisMessage(operation.getMessage("In"));
                    }
                    if (responseRMMessage.getMessageType() == 4) {
                        responseMessageContext.setAxisOperation(SpecSpecificConstants.getWSRMOperation(4, responseRMMessage.getRMSpecVersion(), responseMessageContext.getAxisService()));
                        responseMessageContext.setOperationContext(null);
                    }
                }
                if (msgCtx.getOptions().isUseSeparateListener() && !syncResponseBuilt) {
                    msgCtx.getTransportOut().getSender().cleanup(msgCtx);
                    return;
                }
                responseMessageContext.setServerSide(true);
                if (responseMessageContext.getSoapAction() == null) {
                    responseMessageContext.setSoapAction("");
                }
                if (resenvelope != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("SenderWorker::disable addressing inbound checks, driving response through axis engine " + responseMessageContext));
                    }
                    responseMessageContext.setProperty("addressing.validateInvocationPattern", (Object)Boolean.FALSE);
                    Handler.InvocationResponse response = AxisEngine.receive((MessageContext)responseMessageContext);
                }
            }
            catch (Exception e) {
                String message = SandeshaMessageHelper.getMessage("noValidSyncResponse");
                if (!log.isDebugEnabled()) break block23;
                log.debug((Object)message, (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SenderWorker::checkForSyncResponses");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Exception e, RMMsgContext outRMMsg, StorageManager storageManager) throws SandeshaStorageException {
        Transaction transaction = null;
        try {
            String internalSequenceId = (String)outRMMsg.getProperty("Sandesha2InternalSequenceId");
            if (internalSequenceId == null) {
                internalSequenceId = this.senderBean.getInternalSequenceID();
            }
            if (internalSequenceId != null) {
                transaction = storageManager.getTransaction();
                RMSBean bean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
                if (bean != null) {
                    bean.setLastSendError(e);
                    bean.setLastSendErrorTimestamp(System.currentTimeMillis());
                    storageManager.getRMSBeanMgr().update(bean);
                }
                if (transaction != null) {
                    transaction.commit();
                    transaction = null;
                }
            }
        }
        catch (Exception e1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e1);
            }
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
                transaction = null;
            }
        }
    }
}

