/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.AbstractIssuerConfig;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.derivedKey.P_SHA1;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TokenIssuerUtil {
    public static final String ENCRYPTED_KEY = "EncryptedKey";
    public static final String BINARY_SECRET = "BinarySecret";

    public static byte[] getSharedSecret(RahasData data, int keyComputation, int keySize) throws TrustException {
        boolean reqEntrPresent = data.getRequestEntropy() != null;
        try {
            if (reqEntrPresent && keyComputation != 3) {
                if (keyComputation == 2) {
                    data.setResponseEntropy(UsernameTokenUtil.generateNonce((int)(keySize / 8)));
                    P_SHA1 p_sha1 = new P_SHA1();
                    return p_sha1.createKey(data.getRequestEntropy(), data.getResponseEntropy(), 0, (long)(keySize / 8));
                }
                return data.getRequestEntropy();
            }
            return TokenIssuerUtil.generateEphemeralKey(keySize);
        }
        catch (WSSecurityException e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
    }

    public static void handleRequestedProofToken(RahasData data, int wstVersion, AbstractIssuerConfig config, OMElement rstrElem, Token token, Document doc) throws TrustException {
        OMElement reqProofTokElem = TrustUtil.createRequestedProofTokenElement(wstVersion, rstrElem);
        if (config.keyComputation == 2 && data.getRequestEntropy() != null) {
            OMElement respEntrElem = TrustUtil.createEntropyElement(wstVersion, rstrElem);
            String entr = Base64Utils.encode((byte[])data.getResponseEntropy());
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, respEntrElem, "/Nonce");
            binSecElem.setText(entr);
            OMElement compKeyElem = TrustUtil.createComputedKeyElement(wstVersion, reqProofTokElem);
            compKeyElem.setText(data.getWstNs() + "/CK/PSHA1");
        } else if (ENCRYPTED_KEY.equals(config.proofKeyType)) {
            WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(doc);
            ClassLoader classLoader = data.getInMessageContext().getAxisService().getClassLoader();
            Crypto crypto = config.cryptoElement != null ? CommonUtil.getCrypto(TrustUtil.toProperties(config.cryptoElement), classLoader) : CommonUtil.getCrypto(config.cryptoPropertiesFile, classLoader);
            SecretKey symmetricKey = null;
            try {
                KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
                symmetricKey = keyGen.generateKey();
                encrKeyBuilder.setKeyIdentifierType(8);
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorCreatingSecretKey", e);
            }
            try {
                encrKeyBuilder.setUseThisCert(data.getClientCert());
                encrKeyBuilder.prepare(crypto, symmetricKey);
            }
            catch (WSSecurityException e) {
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{data.getClientCert().getSubjectDN().getName()});
            }
            Element encryptedKeyElem = encrKeyBuilder.getEncryptedKeyElement();
            Element bstElem = encrKeyBuilder.getBinarySecurityTokenElement();
            if (bstElem != null) {
                reqProofTokElem.addChild((OMNode)((OMElement)bstElem));
            }
            reqProofTokElem.addChild((OMNode)((OMElement)encryptedKeyElem));
            token.setSecret(encrKeyBuilder.getEncryptedKeySHA1().getBytes());
        } else if (BINARY_SECRET.equals(config.proofKeyType)) {
            byte[] secret = TokenIssuerUtil.getSharedSecret(data, config.keyComputation, config.keySize);
            OMElement binSecElem = TrustUtil.createBinarySecretElement(wstVersion, reqProofTokElem, null);
            binSecElem.setText(Base64Utils.encode((byte[])secret));
            token.setSecret(secret);
        } else {
            throw new IllegalArgumentException(config.proofKeyType);
        }
    }

    private static byte[] generateEphemeralKey(int keySize) throws TrustException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] temp = new byte[keySize / 8];
            random.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new TrustException("errorCreatingSymmKey", e);
        }
    }
}

