/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.web.filters.HttpHeaderFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFrameOptionsFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(XFrameOptionsFilter.class);
    private String headerValue = "DENY";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (this.isXFrameSameOriginAllowed()) {
            this.headerValue = "SAMEORIGIN";
        }
        LOG.debug("X-Frame-Options is configured: {}", (Object)this.headerValue);
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.addHeader("X-Frame-Options", this.headerValue);
    }
}

