/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.tokenizer;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.camel.builder.TokenizerBuilder;
import org.apache.camel.model.TokenizerImplementationDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Tokenizer;
import org.apache.camel.util.StringHelper;

@Metadata(firstVersion="4.8.0", label="eip,transformation,ai", title="LangChain4J Tokenizer")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="langChain4jTokenizerImplementation")
public class LangChain4jTokenizerDefinition
extends TokenizerImplementationDefinition {
    @XmlAttribute(required=true)
    @Metadata(javaType="org.apache.camel.model.tokenizer.TokenizerType", required=true, enums="OPEN_AI,AZURE,QWEN")
    private String tokenizerType;
    @XmlAttribute(required=true)
    @Metadata(javaType="java.lang.Integer", required=true)
    private String maxTokens;
    @XmlAttribute(required=true)
    @Metadata(javaType="java.lang.Integer", required=true)
    private String maxOverlap;
    @XmlAttribute(required=true)
    @Metadata(javaType="java.lang.String", required=false)
    private String modelName;

    public LangChain4jTokenizerDefinition() {
    }

    public LangChain4jTokenizerDefinition(LangChain4jTokenizerDefinition source) {
        super(source);
        this.maxTokens = source.maxTokens;
        this.maxOverlap = source.maxOverlap;
        this.tokenizerType = source.tokenizerType;
        this.modelName = source.modelName;
    }

    public String getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(String maxTokens) {
        this.maxTokens = maxTokens;
    }

    public String getMaxOverlap() {
        return this.maxOverlap;
    }

    public void setMaxOverlap(String maxOverlap) {
        this.maxOverlap = maxOverlap;
    }

    public String getTokenizerType() {
        return this.tokenizerType;
    }

    public void setTokenizerType(String tokenizerType) {
        this.tokenizerType = tokenizerType;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public LangChain4jTokenizerDefinition copyDefinition() {
        throw new UnsupportedOperationException("Must be implemented in the concrete classes");
    }

    protected static String toName(String name) {
        return "langChain4j" + StringHelper.capitalize((String)name);
    }

    @XmlTransient
    public static abstract class Builder
    implements TokenizerBuilder<LangChain4jTokenizerDefinition> {
        private int maxTokens;
        private int maxOverlap;
        private String modelName;
        private TokenizerType tokenizerType;
        private Tokenizer.Configuration configuration;

        public Builder maxSegmentSize(int maxSegmentSize) {
            this.maxTokens = maxSegmentSize;
            return this;
        }

        @Deprecated
        public Builder maxTokens(int maxTokens) {
            return this.maxSegmentSize(maxTokens);
        }

        public Builder maxTokens(int maxTokens, String modelName) {
            return this.maxSegmentSize(maxTokens).modelName(modelName);
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder maxOverlap(int maxOverlap) {
            this.maxOverlap = maxOverlap;
            return this;
        }

        public Builder using(TokenizerType tokenizer) {
            this.tokenizerType = tokenizer;
            return this;
        }

        public Builder configuration(Tokenizer.Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        protected void setup(LangChain4jTokenizerDefinition tokenizer) {
            if (this.configuration != null) {
                tokenizer.setConfiguration(this.configuration);
            } else {
                tokenizer.setMaxTokens(Integer.toString(this.maxTokens));
                tokenizer.setMaxOverlap(Integer.toString(this.maxOverlap));
                tokenizer.setTokenizerType(this.tokenizerType.name());
                tokenizer.setModelName(this.modelName);
            }
            tokenizer.setTokenizerName(this.name());
        }

        protected abstract String name();
    }

    @XmlTransient
    public static enum TokenizerType {
        OPEN_AI,
        AZURE,
        QWEN;

    }
}

