/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="3.0.0", label="dataformat,transformation", title="JSonApi")
@XmlRootElement(name="jsonApi")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonApiDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String dataFormatTypes;
    @XmlTransient
    private Class<?>[] dataFormatTypeClasses;
    @XmlAttribute
    private String mainFormatType;
    @XmlTransient
    private Class<?> mainFormatTypeClass;

    public JsonApiDataFormat() {
        super("jsonApi");
    }

    protected JsonApiDataFormat(JsonApiDataFormat source) {
        super(source);
        this.dataFormatTypes = source.dataFormatTypes;
        this.dataFormatTypeClasses = source.dataFormatTypeClasses;
        this.mainFormatType = source.mainFormatType;
        this.mainFormatTypeClass = source.mainFormatTypeClass;
    }

    private JsonApiDataFormat(Builder builder) {
        this();
        this.dataFormatTypes = builder.dataFormatTypes;
        this.dataFormatTypeClasses = builder.dataFormatTypeClasses;
        this.mainFormatType = builder.mainFormatType;
        this.mainFormatTypeClass = builder.mainFormatTypeClass;
    }

    @Override
    public JsonApiDataFormat copyDefinition() {
        return new JsonApiDataFormat(this);
    }

    public String getDataFormatTypes() {
        return this.dataFormatTypes;
    }

    public void setDataFormatTypes(String dataFormatTypes) {
        this.dataFormatTypes = dataFormatTypes;
    }

    public Class<?>[] getDataFormatTypeClasses() {
        return this.dataFormatTypeClasses;
    }

    public void setDataFormatTypeClasses(Class<?>[] dataFormatTypeClasses) {
        this.dataFormatTypeClasses = dataFormatTypeClasses;
    }

    public String getMainFormatType() {
        return this.mainFormatType;
    }

    public void setMainFormatType(String mainFormatType) {
        this.mainFormatType = mainFormatType;
    }

    public Class<?> getMainFormatTypeClass() {
        return this.mainFormatTypeClass;
    }

    public void setMainFormatTypeClass(Class<?> mainFormatTypeClass) {
        this.mainFormatTypeClass = mainFormatTypeClass;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<JsonApiDataFormat> {
        private String dataFormatTypes;
        private Class<?>[] dataFormatTypeClasses;
        private String mainFormatType;
        private Class<?> mainFormatTypeClass;

        public Builder dataFormatTypes(Class<?>[] dataFormatTypes) {
            this.dataFormatTypeClasses = dataFormatTypes;
            return this;
        }

        public Builder dataFormatTypes(String dataFormatTypes) {
            this.dataFormatTypes = dataFormatTypes;
            return this;
        }

        public Builder mainFormatType(Class<?> mainFormatType) {
            this.mainFormatTypeClass = mainFormatType;
            return this;
        }

        public Builder mainFormatType(String mainFormatType) {
            this.mainFormatType = mainFormatType;
            return this;
        }

        @Override
        public JsonApiDataFormat end() {
            return new JsonApiDataFormat(this);
        }
    }
}

